/*
 * aud_dbus_lcm_proxy.cpp
 *
 *  Created on: 6th October, 2016
 *      Author: paj5kor
 */

#include "controllerplugin_Trace.h"
#ifndef USE_DLT_TRACE
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include <etrace_if.h>
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_AMCONTROLLERPLUGIN
#include "trcGenProj/Header/aud_dbus_lcm_proxy.cpp.trc.h"
#endif

#include "LcmDBusProxy/aud_dbus_lcm_proxy.h"
#include "CAmControlSenderBase.h"

#define AUDIO_LCM_BUS_NAME       "org.bosch.cm.lcmccadbusgw.LcmccadbusgwAsf"
#define AUDIO_LCM_OBJECT_PATH  "/com/bosch/cm/lcmccadbusgw/server/LcmDbusFi"

aud_dbus_lcm_proxy* aud_dbus_lcm_proxy::m_poSelfPtr = NULL;
/**
 * Constructor
 */
aud_dbus_lcm_proxy::aud_dbus_lcm_proxy(aud_dbus_lcm_bus_watcher* pWatcher,GBusType bus_type,
  CAmControlSenderBase& controlSenderBase, am::IAmControlReceiverShadow& receiverShadow, am::IAmControlReceive& controlReceive)
:
m_poProxy(NULL)
,m_pWatcher(pWatcher)
,m_busname(AUDIO_LCM_BUS_NAME)
,m_objpath(AUDIO_LCM_OBJECT_PATH)
,m_bus_type(bus_type)
,m_receiverShadow(receiverShadow)
,m_ControlReceive(controlReceive)
,m_ControlSenderBase(controlSenderBase)
{
  ETG_TRACE_USR3(("aud_dbus_lcm_proxy : Constructor"));
  m_poSelfPtr = this;
  if(m_pWatcher)
  {
    ETG_TRACE_USR3(("aud_dbus_lcm_proxy : Cal bRegisterNotifyBusName of watcher class"));
    //Register for notifications with bus name watcher
    if(!m_pWatcher->bRegisterNotifyBusName(m_busname.c_str(),this))
    {
      ETG_TRACE_USR3(("aud_dbus_lcm_proxy : Normal assert was triggered before"));
      NORMAL_M_ASSERT_ALWAYS();
    }
  }
}

/**
 * Destructor
 */
aud_dbus_lcm_proxy::~aud_dbus_lcm_proxy()
{
  if(m_pWatcher)
  {
    //Unregister for notifications
    m_pWatcher->vUnRegisterNotifyBusName(m_busname.c_str());
    m_pWatcher = NULL;
  }
  //Delete proxy object
  if(m_poProxy)
  {
    g_object_unref (m_poProxy);//Drop the reference to proxy
    m_poProxy = NULL;
  }
}
/**
 * Function triggered by the watcher when the server becomes available
 */
void aud_dbus_lcm_proxy::vOnServerAvailable(GDBusConnection * connection)
{
  ETG_TRACE_USR4(("aud_dbus_lcm_proxy::vOnServerAvailable::Server is available now"));

  GError *error = NULL;
  tU16 handlerID = 0;
  m_poProxy = org_bosch_cm_lcm_dbus_fi_lcm_dbus_fi_service_proxy_new_for_bus_sync(
                m_bus_type,
                G_DBUS_PROXY_FLAGS_NONE,
                m_busname.c_str(),
                m_objpath.c_str(),
                NULL,
                &error);
  if(error != NULL)
  {
    ETG_TRACE_FATAL(("Failed to create a proxy : %s",error->message));
    g_error_free(error);
    return;
  }

  if(m_poProxy == NULL)
  {
    ETG_TRACE_USR4(("aud_dbus_lcm_proxy::vOnServerAvailable::m_poProxy is NULL"));
    return;
  }
  else
  {
    ETG_TRACE_USR4(("Proxy to dbus LCM service is created successfully"));
  }

  ETG_TRACE_USR4(("aud_dbus_lcm_proxy::vOnServerAvailable:: audioState = %d",org_bosch_cm_lcm_dbus_fi_lcm_dbus_fi_service_get_audio_state(m_poProxy)));
  ETG_TRACE_USR4(("aud_dbus_lcm_proxy::vOnServerAvailable:: register for property audio-state in LCM"));
  handlerID = (tU16)g_signal_connect(m_poProxy, "notify::audio-state", G_CALLBACK(vHandle_GetLCMAudioState), NULL);
  ETG_TRACE_USR4(("aud_dbus_lcm_proxy::vOnServerAvailable:: handlerID = %d",handlerID));
}
/**
 * Function triggered by the watcher when the server becomes unavailable
 */
void aud_dbus_lcm_proxy::vOnServerUnAvailable(bpstl::string sBusName)
{
  ETG_TRACE_USR4(("aud_dbus_lcm_proxy::vOnServerUnAvailable::Server is unavailable : %s",sBusName.c_str()));
  if(m_poProxy)
  {
    g_object_unref (m_poProxy);//Drop the reference to proxy
    m_poProxy = NULL;
  }
}

/****************************************************************************************************
                SYNCHRONOUS METHOD CALLS
******************************************************************************************************/
/**
* Synchronous method call  : get_version_sync
*/
void aud_dbus_lcm_proxy::vHandle_GetLCMAudioState(OrgBoschCmLcm_dbus_fiLcm_dbus_fi_service *object, guint* audioState, gpointer pUserData)
{
  ETG_TRACE_USR4(("aud_dbus_lcm_proxy::vHandle_GetLCMAudioState::audioState = %d",(*audioState)));
  (tVoid) pUserData;  // To avoid lint warning
  (tVoid) object;    // To avoid lint warning
  m_poSelfPtr->vSetAutoplay(org_bosch_cm_lcm_dbus_fi_lcm_dbus_fi_service_get_audio_state(object));
}

void aud_dbus_lcm_proxy::vSetAutoplay(guint audioState)
{
  ETG_TRACE_USR4(("aud_dbus_lcm_proxy::vSetAutoplay:audioState = %d",audioState));
  m_ControlSenderBase.m_eAudioState = (am::am_SystemAudioState_e)audioState;
  m_receiverShadow.vSwitchThreadContext<CAmControlSenderBase>(&m_ControlSenderBase, &CAmControlSenderBase::vHandleLCMState);
}


